#include <bits/stdc++.h>
using namespace std;

struct SegmentnoStablo {
    int n;
    vector<long long> st;
    SegmentnoStablo(int sz=0) { init(sz); }
    void init(int sz) {
        n = 1;
        while (n < sz) n <<= 1;
        st.assign(2*n, 0);
    }
    void postavi(int poz, long long val) {
        int idx = poz + n;
        st[idx] = val;
        for(idx >>= 1; idx; idx >>= 1)
            st[idx] = st[2*idx] + st[2*idx+1];
    }
    long long upit(int l, int r) {
        l += n; r += n;
        long long res = 0;
        while(l <= r) {
            if(l&1) res += st[l++];
            if(!(r&1)) res += st[r--];
            l >>= 1; r >>= 1;
        }
        return res;
    }
};

int main(){
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    
    int n, q;
    cin >> n >> q;
    vector<int> a(n);
    int max_a = 0;

    for(int i = 0; i < n; i++){
        cin >> a[i];
        max_a = max(max_a, a[i]);


    }
    SegmentnoStablo st(max_a+5);
    vector<int> cnt(max_a+5, 0);
    for(int i = 0; i < n; i++){
        cnt[a[i]]++;


    }
    for(int i = 1; i <= max_a; i++){
        st.postavi(i, cnt[i]*i);


    }
    while(q--){
        int t;
        cin >> t;
        if(t == 1){
            int k;
            cin >> k;
            vector<int> freq(max_a+5, 0);
            for(int i = 0; i < k; i++) freq[a[i]]++;
            long long suma = 0;
            for(int i = 1; i <= max_a; i++){
                if(freq[i] % 2 == 1){
                    suma += i;


                }


            }
            cout << suma << "\n";
        } else {
            int x, y;
            cin >> x >> y;
            x--;
            st.postavi(a[x], st.upit(a[x], a[x]) - a[x]);
            cnt[a[x]]--;
            a[x] = y;
            st.postavi(a[x], st.upit(a[x], a[x]) + a[x]);
            cnt[a[x]]++;



        }

    }
    return 0;
}